﻿/*
version:		1.4
*/

function loadFile( filename:String, dest_array:Array, callTarget )
{
	trace("");
	trace("loadFile()");
	trace("filename: "+filename);
	trace("dest_array: "+dest_array);
	trace("callTarget: "+callTarget);
	trace("this: "+this);

	// create an object to store parameters across functions
	this.newData_obj = new Object();
	this.newData_obj.dest_array;		// reference to new array
	this.newData_obj.callTarget;			// reference for callback functions
	// Store parameters in the movieclip,  to preserve them across function calls
	newData_obj.dest_array = dest_array;		// store data destination
	newData_obj.callTarget = callTarget;			// store callback target
	//newData_obj.dest_array = new Array();		// clear old data
	//newData_obj.data = undefined;		// clear old data
	trace("newData_obj.dest_array: "+newData_obj.dest_array);
	trace("newData_obj.callTarget: "+newData_obj.callTarget);
	
	this.myLoader = new LoadVars();
	// load the file
	this.myLoader.onLoad = function( success:Boolean )
	{
		trace("");
		trace("myLoader.onLoad()");
		if (success)
		{
			// Loaded the file
			parseLoadedData( this.data );
		}else{
			// File not found
			newData_obj.callTarget.onLoadError();
		}
	}
	
	myLoader.load( filename );
	//loadVariables(filename, newData_obj);

	newData_obj.callTarget.onLoadStart();		// Callback:  Loading has begun
	
	//repeatCheckLoad = setInterval(checkLoad, 100);		// Periodically check if loading has finished
}



function parseLoadedData( newData:String )
{
	trace("");
	trace("parseLoadedData()");
	trace("this: "+this);
	var readCharacter = "";
	var newName = "";
	trace("newData.length: "+newData.length);
	for ( var i = 0; i < newData.length; i++)
	{
		readCharacter = newData.charAt(i);
		trace("readCharacter: "+readCharacter);
		trace("ascii code: "+newData.charCodeAt(i) );
		if (newData.charCodeAt(i) == 10 )
		{
			// It's the end of this line, so add the name
			if (newName != "")
			{
				newData_obj.dest_array.push( newName );
			}
			newName = "";
		}
		else if (newData.charCodeAt(i) == 13 )
		{
			// extra carriage return code, so ignore it
		}
		else
		{
			// assume this character is part of the current name, so add it
			newName += readCharacter;
		}// END if
	}// END for
	// if the file ends on something other than a carriage return, assume there's one more name to add

	// back up to look at the last character
	i--;
	if (newData.charCodeAt(i) != 13  &&  newData.charCodeAt(i) != 10 )
	{
		trace("index: "+i);
		trace("newName = "+newName);
		trace("ascii code: "+newData.charCodeAt(i));
		trace("it's not a carriage return, so there must be one more name, add it to the list.");
		newData_obj.dest_array.push( newName );
	}
	
	// Output
	newData_obj.callTarget.onLoadInit( newData_obj.dest_array );
	
	// CLEAN-UP
	delete newData_obj;
	delete myLoader;
	/*
	delete this.onLoadStart;
	delete this.onLoadInit;
	delete this.onLoadError;
	*/
}